/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.EventLogInitTable;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;

public class BlockIDListSumBean
extends PanelBean
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDBBT";
    private static final String TRACE_MASKF = "XLOGDBBF";
    private static final String TRACE_MASKD = "XLOGDBBD";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private transient ItemDescriptor[] m_idEventLogTable;
    private transient int[] m_iEventLogTableSelection;
    private transient ColumnDescriptor[] m_cdEventLogTableStructure;
    private transient String[] m_sBlockIDChoiceSelection;
    private LogBlock[] _logBlocks;
    private EventLogData _eventLogData;
    private transient boolean _blockPrimaryFound;
    private transient boolean _blockStandardFound;
    private transient boolean _blockSecondaryFound;
    private transient boolean _blockModifyFound;
    private transient boolean _blockSystemEventFound;
    private transient boolean _blockEngDataFound;
    private transient boolean _blockMcodeReasonFound;
    private transient boolean _blockDataFound;
    public static final String BUTTON_OK = "OkButton";
    public static final String BUTTON_CANCEL = "CancelButton";
    public static final String BLK_RADIO_BUTTON_PRIMARY = "PrimaryDataBlockItem";
    public static final String BLK_RADIO_BUTTON_STANDARD = "StandardDataBlockItem";
    public static final String BLK_RADIO_BUTTON_SECONDARY = "SecondaryDataBlockItem";
    public static final String BLK_RADIO_BUTTON_MODIFY = "ModifyDataBlockItem";
    public static final String BLK_RADIO_BUTTON_SYSTEM_EVENT = "SystemEventMsgItem";
    public static final String BLK_RADIO_BUTTON_ENG_DATA = "EngDataBlockItem";
    public static final String BLK_RADIO_BUTTON_MCODE_ERROR = "MicrocodeErrorInfoItem";
    public static final String BLK_RADIO_BUTTON_DATA_BLOCK = "DataBlockItem";
    public static final String BLK_RADIO_BUTTON_HDW_BLOCK = "HardwareBlockItem";
    public static final String BLOCK_ID_RADIO_BUTTON = "radioButton";

    public ColumnDescriptor[] getEventLogTableRowStructure() {
        return this.m_cdEventLogTableStructure;
    }

    public int getEventLogTableRowStatus() {
        return 3;
    }

    public int getEventLogTableRowCount() {
        return 1;
    }

    public ItemDescriptor[] getEventLogTableRowAt(int index) {
        return this.m_idEventLogTable;
    }

    public void setEventLogTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idEventLogTable = items;
    }

    public int[] getEventLogTableSelection() {
        return this.m_iEventLogTableSelection;
    }

    public void setEventLogTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iEventLogTableSelection = selected;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, " -> BlockIDListSumBean.prepare()");
        this.initRadioButtons();
        this.preSelectRadioButton();
        Trace.trace(TRACE_MASKT, " <- BlockIDListSumBean.prepare()");
    }

    public String[] getBlockIDChoiceSelection() {
        return this.m_sBlockIDChoiceSelection;
    }

    public void setBlockIDChoiceSelection(String[] selected) throws IllegalUserDataException {
        this.m_sBlockIDChoiceSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKF, " -> BlockIDListSumBean.load()");
        this.m_cdEventLogTableStructure = new ColumnDescriptor[0];
        this.m_iEventLogTableSelection = new int[0];
        this.m_sBlockIDChoiceSelection = new String[1];
        this.m_idEventLogTable = EventLogInitTable.setEventTableData(this._eventLogData);
        Trace.trace(TRACE_MASKF, " <- BlockIDListSumBean.load()");
    }

    public void setEventLogData(EventLogData eventLogData) {
        this._eventLogData = eventLogData;
    }

    public void setLogBlocks(LogBlock[] logBlocks) {
        this._logBlocks = logBlocks;
    }

    private void initRadioButtons() {
        this._blockPrimaryFound = false;
        this._blockStandardFound = false;
        this._blockSecondaryFound = false;
        this._blockModifyFound = false;
        this._blockSystemEventFound = false;
        this._blockEngDataFound = false;
        this._blockMcodeReasonFound = false;
        this._blockDataFound = false;
        this.userTaskManager.setShown(BLK_RADIO_BUTTON_PRIMARY, false);
        this.userTaskManager.setShown(BLK_RADIO_BUTTON_STANDARD, false);
        this.userTaskManager.setShown(BLK_RADIO_BUTTON_SECONDARY, false);
        this.userTaskManager.setShown(BLK_RADIO_BUTTON_MODIFY, false);
        this.userTaskManager.setShown(BLK_RADIO_BUTTON_SYSTEM_EVENT, false);
        this.userTaskManager.setShown(BLK_RADIO_BUTTON_ENG_DATA, false);
        this.userTaskManager.setShown(BLK_RADIO_BUTTON_MCODE_ERROR, false);
        this.userTaskManager.setShown(BLK_RADIO_BUTTON_DATA_BLOCK, false);
        this.userTaskManager.setShown(BLK_RADIO_BUTTON_HDW_BLOCK, false);
        int lowerSec = 4;
        int upperSec = -17;
        upperSec &= 0xFF;
        lowerSec &= 0xFF;
        int numberOfBlocks = this._logBlocks.length;
        for (int i = 0; i < numberOfBlocks; ++i) {
            byte by = this._logBlocks[i].getBlockId();
            Trace.trace(TRACE_MASKF, " blockId=" + HexString.toHex(by, true) + " num=" + numberOfBlocks);
            if (by == 3) {
                this.userTaskManager.setShown(BLK_RADIO_BUTTON_PRIMARY, true);
                this._blockPrimaryFound = true;
                continue;
            }
            if (by == 1) {
                this.userTaskManager.setShown(BLK_RADIO_BUTTON_STANDARD, true);
                this._blockStandardFound = true;
                continue;
            }
            if (by == 0) {
                this.userTaskManager.setShown(BLK_RADIO_BUTTON_MODIFY, true);
                this._blockModifyFound = true;
                continue;
            }
            if (by == -15) {
                this.userTaskManager.setShown(BLK_RADIO_BUTTON_SYSTEM_EVENT, true);
                this._blockSystemEventFound = true;
                continue;
            }
            if (by == 2) {
                this.userTaskManager.setShown(BLK_RADIO_BUTTON_ENG_DATA, true);
                this._blockEngDataFound = true;
                continue;
            }
            if (by == -16) {
                this.userTaskManager.setShown(BLK_RADIO_BUTTON_MCODE_ERROR, true);
                this._blockMcodeReasonFound = true;
                continue;
            }
            if (by == -14) {
                this.userTaskManager.setShown(BLK_RADIO_BUTTON_DATA_BLOCK, true);
                this._blockDataFound = true;
                continue;
            }
            if (by == -12) {
                this.userTaskManager.setShown(BLK_RADIO_BUTTON_HDW_BLOCK, true);
                this._blockDataFound = true;
                continue;
            }
            int tmpBlockId = by;
            if ((tmpBlockId &= 0xFF) >= lowerSec && tmpBlockId <= upperSec) {
                this.userTaskManager.setShown(BLK_RADIO_BUTTON_SECONDARY, true);
                this._blockSecondaryFound = true;
                continue;
            }
            Trace.trace(TRACE_MASKF, " UNKNOWN BLOCKID=" + HexString.toHex(by, true));
        }
    }

    private void preSelectRadioButton() {
        if (this._blockSystemEventFound) {
            this.m_sBlockIDChoiceSelection[0] = BLK_RADIO_BUTTON_SYSTEM_EVENT;
        } else if (this._blockPrimaryFound) {
            this.m_sBlockIDChoiceSelection[0] = BLK_RADIO_BUTTON_PRIMARY;
        } else if (this._blockStandardFound) {
            this.m_sBlockIDChoiceSelection[0] = BLK_RADIO_BUTTON_STANDARD;
        } else if (this._blockSecondaryFound) {
            this.m_sBlockIDChoiceSelection[0] = BLK_RADIO_BUTTON_SECONDARY;
        } else if (this._blockModifyFound) {
            this.m_sBlockIDChoiceSelection[0] = BLK_RADIO_BUTTON_MODIFY;
        } else if (this._blockEngDataFound) {
            this.m_sBlockIDChoiceSelection[0] = BLK_RADIO_BUTTON_ENG_DATA;
        } else if (this._blockMcodeReasonFound) {
            this.m_sBlockIDChoiceSelection[0] = BLK_RADIO_BUTTON_MCODE_ERROR;
        } else if (this._blockDataFound) {
            this.m_sBlockIDChoiceSelection[0] = BLK_RADIO_BUTTON_DATA_BLOCK;
        } else if (this._blockDataFound) {
            this.m_sBlockIDChoiceSelection[0] = BLK_RADIO_BUTTON_HDW_BLOCK;
        }
        Trace.trace(TRACE_MASKF, " Radio button preselected=" + this.m_sBlockIDChoiceSelection[0]);
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> BlockIDListSumBean.panelAction()");
        PanelTaskletRequest request = null;
        try {
            this.userTaskManager.storeAllElements();
            String command = evt.getActionCommand();
            Trace.trace(TRACE_MASKF, "command = " + command);
            request = new PanelTaskletRequest();
            request.setData("event", evt);
            request.setData("panelName", "blockId");
            if (command.equals(BUTTON_OK)) {
                Trace.trace(TRACE_MASKF, "Block id OK button selected");
                String[] userChoice = this.getBlockIDChoiceSelection();
                if (userChoice == null || userChoice.length == 0) {
                    BaseMessageText myMess = new BaseMessageText("LOGBLKSEL");
                    LocalizableText lStrTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.blockid.title");
                    CommonMsgApp.showMessageBox(this.userTaskManager, lStrTitle, myMess, MsgType.INFORMATION_MESSAGE);
                } else {
                    Trace.trace(TRACE_MASKF, "Radio button=" + userChoice[0]);
                    request.setData(BLOCK_ID_RADIO_BUTTON, userChoice[0]);
                    this.postTaskletRequest(request);
                }
            } else {
                this.postTaskletRequest(request);
            }
            Trace.trace(TRACE_MASKT, "<- BlockIDListSumBean.panelAction()");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error caught in BlockIDListSumBean.panelAction() exc = " + e);
            HException he = new HException(e);
            new FrameworkLog(_logInfo, 1298, he).log();
            request.setData("panelError", "terminate");
            this.postTaskletRequest(request);
        }
    }
}

